; Copyright (C) 2002-2007 by Autodesk, Inc.
;
; Permission to use, copy, modify, and distribute this software
; for any purpose and without fee is hereby granted, provided that
; the above copyright notice appears in all copies and that both
; the copyright notice and the limited warranty and restricted rights
; notice below appear in all supporting documentation.
;
; AUTODESK, INC. PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
; AUTODESK, INC. SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
; MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
; DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
; UNINTERRUPTED OR ERROR FREE.
;
; Use, duplication, or disclosure by the U.S. Government is subject to
; restrictions set forth in FAR 52.227-19 (Commercial Computer
; Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
; (Rights in Technical Data and Computer Software), as applicable.
;
; 
; ----------------  W D R E D E F . L S P  -----------------------------------
; PURPOSE: allow behavior of certain internal AutoCAD Electrical functions to be
;          redefined. Edit below. Then use Visual LISP editor to create a new
;          version of "wdredef.fas". Copy this new version and overwrite 
;          existing installed version (after making backup!) found in the
;          main executable folder (ex: "c:\program files\autodesk\acade 200x\")
;          Restart AcadE. Test.


; Increment Character String function - for "next" sequential wire number
(defun wd_redef_increment_str_wirenum ( str val / )
  ; --- Substitute line below with a custom function call or block of code
  (setq str (wd_1_increment_str str val)) ; call the default AcadE function
  ; --- End of substitution
  str ; return character string
)

; Increment Character String function - for "next" sequential component tag 
(defun wd_redef_increment_str_comp_tag (str val / )
  ; --- Substitute line below with a custom function call or block of code
  (setq str (wd_1_increment_str str val)) ; call the default AcadE function
  ; --- End of substitution
  str ; return character string
)

; Break down tag format string. Example: "%F-%N" --> (list "%F" "-" "%N")
(defun wd_redef_breakdown_fmt ( param_lst / lst tagfmt_str)
  ; "param_lst" = list of 1 to 3 params where
  ;  (car param_lst) = format string (ex: "%F-%N")
  ;  (cadr param_lst) = entity name or handle
  ;  (caddr param_lst) = (optional drawing name or dbx handle, missing or nil=active drawing)
  (if (not (listp param_lst))
    (setq tagfmt_str param_lst)
  ; ELSE
    (setq tagfmt_str (car param_lst))
  )
  ; --- Substitute line below with a custom function call or block of code
  (setq lst (wd_1_breakdown_fmt tagfmt_str)) ; call the default AcadE function
  ; --- End of substitution
  lst ; return list
)  

; -- ** 17-Sep-07 NEHolt
(defun wd_redef_catmfg_strcase ( str / )
  ; To enable MFG/CAT/ASSYCODE entries in dialog edit boxes to be forced to upper case
  ; Uncommend line below to force entries to go upper-case
;  (setq str (ace_strcase str))
  str ; return "str" value
)

; -- ** 24-Jan-08 NEHolt
(defun wd_redef_sort_int_atoi ( str / rtn )
  ; To alter the way "numeric / alpha" sorting on string "str" is evaluated in
  ; function (wd_dsp_quadintsort...) 
  ; Filter out any "nil" values
  (if (not str)
    (setq rtn 0)
  ; ELSE
    (progn
      (setq rtn (atoi str))
      (cond
        ((/= rtn 0)) ; some value
        ((= str ""))
        ((= str "0"))
;;; *******        
;;; Uncomment these next 5 lines of code to enable "integer" sort mode to
;;; look for embedded numberic value inside of the passed text substring. 
;;; Comment out these next 5 lines of code to enable integer sort on only
;;; any leading numeric value prefix of the passed text string (default behavior)
;;; "Comment out" means put a ";" in first char position of the line of code
;        (T ; evaluated to 0. Look for embedded numeric value
;          (while (AND (/= (setq str (substr str 2)) "")
;                      (OR (= (substr str 1 1) "-") ; ignore negative sign
;                          (= (setq rtn (atoi str)) 0)))
;        ) )
;;; *******         
  ) ) )
  rtn ; return 0 or embedded integer value found in "str"
)    
